USE [PCS]
GO

/****** Object:  View [dbo].[vUtilitiesIndexFragmentation]    Script Date: 2/17/2014 1:28:34 PM ******/
DROP VIEW [dbo].[vUtilitiesIndexFragmentation]
GO

/****** Object:  View [dbo].[vUtilitiesIndexFragmentation]    Script Date: 2/17/2014 1:28:34 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [dbo].[vUtilitiesIndexFragmentation]
AS
/*
CREATED 2/14/2014 dh - Get fragmentation info for all indexes above a certain size in the current database  
Used in the Utilities database.
*/
SELECT DB_NAME(ps.database_id) AS [Database Name], OBJECT_NAME(ps.OBJECT_ID) AS [Object Name], 
i.name AS [Index Name], ps.index_id, ps.index_type_desc, ps.avg_fragmentation_in_percent, 
ps.fragment_count, ps.page_count, i.fill_factor, i.has_filter, i.filter_definition
,	CASE  
		when avg_fragmentation_in_percent BETWEEN 10 and 30 then 'Reorganize'
		when avg_fragmentation_in_percent > 30 then 'Rebuild'
	END AS [action_to_take]

 
FROM sys.dm_db_index_physical_stats(DB_ID(),NULL, NULL, NULL , N'LIMITED') AS ps
INNER JOIN sys.indexes AS i WITH (NOLOCK)
ON ps.[object_id] = i.[object_id] 
AND ps.index_id = i.index_id
WHERE ps.database_id = DB_ID()
AND ps.avg_fragmentation_in_percent >10
AND ps.page_count > 5000
--ORDER BY ps.avg_fragmentation_in_percent DESC OPTION (RECOMPILE);


GO


USE [PCS]
GO

/****** Object:  View [dbo].[vUtilitiesTopCachedSPs]    Script Date: 2/17/2014 1:28:47 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE VIEW [dbo].[vUtilitiesTopCachedSPs]
AS

/*
Created 2/14/2014 DH - shows the top 25 most expensive queries to retune.
*/
-- Top Cached SPs By Avg Elapsed Time (SQL Server 2012)  (Query 45) (SP Avg Elapsed Time)
SELECT TOP(25) p.name AS [SP Name], qs.total_elapsed_time/CASE WHEN qs.execution_count = 0 THEN 1 ELSE qs.execution_count END AS [avg_elapsed_time], 
qs.total_elapsed_time, qs.execution_count, ISNULL(qs.execution_count/DATEDIFF(Minute, qs.cached_time, 
GETDATE()), 0) AS [Calls/Minute]
, qs.total_worker_time/CASE WHEN qs.execution_count = 0 THEN 1 ELSE qs.execution_count END AS [AvgWorkerTime], 
qs.total_worker_time AS [TotalWorkerTime], qs.cached_time
FROM sys.procedures AS p WITH (NOLOCK)
INNER JOIN sys.dm_exec_procedure_stats AS qs WITH (NOLOCK)
ON p.[object_id] = qs.[object_id]
WHERE qs.database_id = DB_ID()
ORDER BY avg_elapsed_time DESC --OPTION (RECOMPILE);




GO

